#include <stdio.h>
#include <stdlib.h>

int * mnozenje = 0;
int * sabiranje = 0;
int * ciljL = 0;
int * ciljR = 0;
int brPrepreka;

void ucitajNiz(int * const niz, int n) {
    for (int i = 0; i < n; i++) {
        scanf("%d", &niz[i]);
    }
}

typedef struct {
    int brVojnika;
    char validno;
} Resenje;

typedef enum {MNOZENJE, SABIRANJE} Grana;

Resenje bolje(Resenje r1, Resenje r2) {
    if (!r1.validno) {
        return r2;
    }
    if (!r2.validno) {
        return r1;
    }
    if (r1.brVojnika > r2.brVojnika) {
        return r1;
    }
    return r2;
}

Resenje resi(Resenje ulaz, Grana grana, int prepreka) {
    if (!ulaz.validno) {
        return ulaz;
    }    
    Resenje r = ulaz;    
    if (grana == MNOZENJE) {
        r.brVojnika *= mnozenje[prepreka];
    } else {
        r.brVojnika += sabiranje[prepreka];
    }
    r.validno = 0;
    if (r.brVojnika >= ciljL[prepreka] && r.brVojnika <= ciljR[prepreka]) {
        r.validno = 1;
    } else {
        return r; //corsokak, grana nema resenja
    }    
    if (prepreka == brPrepreka - 1) {
        return r;
    }    
    return bolje(
        resi(r, MNOZENJE, prepreka + 1),
        resi(r, SABIRANJE, prepreka + 1)
    );
}

int main() {
    int brNivoa;
    scanf("%d", &brNivoa);
    for (int i = 0; i < brNivoa; i++) {
        int brVojnika;
        scanf("%d %d", &brPrepreka, &brVojnika);
        int arrMnozenje[brPrepreka];
        mnozenje = arrMnozenje;
        int arrSabiranje[brPrepreka];
        sabiranje = arrSabiranje;
        int arrCiljL[brPrepreka];        
        ciljL = arrCiljL;
        int arrCiljR[brPrepreka];
        ciljR = arrCiljR;
        ucitajNiz(arrMnozenje, brPrepreka);
        ucitajNiz(arrSabiranje, brPrepreka);
        ucitajNiz(arrCiljL, brPrepreka);
        ucitajNiz(arrCiljR, brPrepreka);        
        Resenje pocetak = {brVojnika, 1};
        int pocetnaPrepreka = 0;
        Resenje r = bolje(
            resi(pocetak, MNOZENJE, pocetnaPrepreka),
            resi(pocetak, SABIRANJE, pocetnaPrepreka)              
        );
        if (!r.validno) {
            printf("nemoguce\n");
        } else {
            printf("%d\n", r.brVojnika);
        }
    }        
    return 0;
}